/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.CarpetBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingSchool
extends AbstractBuilding {
    private static final String SCHOOL = "school";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_CARPET = "carpet";
    @NotNull
    private final List<BlockPos> carpet = new ArrayList<BlockPos>();
    private final Random random = new Random();

    public BuildingSchool(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHOOL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof CarpetBlock) {
            this.carpet.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT carpetTagList = compound.func_150295_c(TAG_CARPET, 10);
        for (int i = 0; i < carpetTagList.size(); ++i) {
            CompoundNBT bedCompound = carpetTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.read(bedCompound, "pos");
            if (this.carpet.contains(pos)) continue;
            this.carpet.add(pos);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (!this.carpet.isEmpty()) {
            @NotNull ListNBT carpetTagList = new ListNBT();
            for (BlockPos pos : this.carpet) {
                CompoundNBT carpetCompound = new CompoundNBT();
                BlockPosUtil.write(carpetCompound, "pos", pos);
                carpetTagList.add((Object)carpetCompound);
            }
            compound.func_218657_a(TAG_CARPET, (INBT)carpetTagList);
        }
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
    }

    @Nullable
    public BlockPos getRandomPlaceToSit() {
        if (this.carpet.isEmpty()) {
            return null;
        }
        BlockPos returnPos = this.carpet.get(this.random.nextInt(this.carpet.size()));
        if (this.colony.getWorld().func_180495_p(returnPos).func_177230_c() instanceof CarpetBlock) {
            return returnPos;
        }
        this.carpet.remove(returnPos);
        return null;
    }
}

